%--------------------------------------------------------------------------
%   Universit� catholique de Louvain
%   CEREM : Centre for research in mechatronics
%   http://www.robotran.be  
%   Contact : robotran@prm.ucl.ac.be
%   Version : ROBOTRAN $Version$
%
%
%   MBsysLab main script template for simple model:
%   -----------------------------------------------
%    This template loads the data file *.mbs and execute the
%    direct dynamic modeuls (time integration of equations of
%    motion). It may be adapted and completed by the user.
%
%   Project : $pendulum_spring_matlab$
%   Author : Team Robotran
%   Date : $Date$ 
%--------------------------------------------------------------------------

%% 1.1. Initialization and Project Loading [mbs_load]
%--------------------------------------------------------------------------
close all; clear variables; clc;                                            % Cleaning of the Matlab workspace
global MBS_user;                                                            % Declaration of the global user structure
MBS_user.process = '';                                                      % Initialisation of the user field "process"

% Project loading
prjname = 'pendulum_spring_matlab';
[mbs_data, mbs_info] = mbs_load(prjname,'default');                         % Option 'default': automatic loading of "$project_name$.mbs" 
                                                                            % Have a look at the content of the mbs_data structure on www.robotran.be

                                                                            
%% 1.2. Coordinate partioning
%--------------------------------------------------------------------------
MBS_user.process = 'part';

opt.part = {'rowperm','yes','threshold',1e-9,'verbose','yes'};
% Options for the coordinate partitioning.

[mbs_part,mbs_data] = mbs_exe_part(mbs_data,opt.part);
% Run the coordinate partitioning process

%% 2.1 Direct dynamics [mbs_exe_dirdyn]
%--------------------------------------------------------------------------
MBS_user.process = 'dirdyn';

opt.dirdyn = {'time',0:0.01:5, 'odemethod','ode45'};                        % Help about options on www.robotran.be

[mbs_dirdyn,mbs_data] = mbs_exe_dirdyn(mbs_data,opt.dirdyn);                % Direct dynamics process (time simulation)

%% 2.2 Sensor calculation
MBS_user.resdirdyn.rodAccZ2 = zeros(length(mbs_dirdyn.tsim),1);
sensId = mbs_get_S_sensor_id(MBS_info, 'RodSensor');

for i=1:length(mbs_dirdyn.tsim)
    % Restoring the state at time i
    t = mbs_dirdyn.tsim(i);
    mbs_data.q = mbs_dirdyn.q(i,:);
    mbs_data.qd = mbs_dirdyn.qd(i,:);
    mbs_data.qdd = mbs_dirdyn.qdd(i,:);

    % Calculate the sensor and save the acceleration at time i
    [rodSens] = mbs_comp_S_sensor(mbs_data,t,sensId);
    MBS_user.resdirdyn.rodAccZ2(i) = rodSens.A(3);
end

%% 2.3 Graphical Results
figure;
plot(mbs_dirdyn.tsim,mbs_dirdyn.q(:,1));                                    % Joint motion time history : joint nb 1 motion
xlabel('Time (sec)');
ylabel('q1 (rad)');
figure;
plot(mbs_dirdyn.tsim,mbs_dirdyn.q(:,2));                                    % Joint motion time history : joint nb 2 motion
xlabel('Time (sec)');
ylabel('q2 (m)');
figure;
plot(mbs_dirdyn.tsim,MBS_user.resdirdyn.rodAccZ2);                          % Sensor vertical acceleration time history
xlabel('Time (sec)');
ylabel('Acceleration (m/s^2)');

%% 3. Closing operations (optional)
%--------------------------------------------------------------------------
mbs_rm_allprjpath;                                                          % Cleaning of the Matlab project paths
mbs_del_glob('MBS_user','MBS_info','MBS_data');                             % Cleaning of the global MBS variables
clc;                                                                        % Cleaning of the Matlab command window
